<?php
/**
 * AIOX Capsules Fallback Page
 * 
 * This page is shown when the main capsules class fails to load
 */

if (!defined('ABSPATH')) {
    exit;
}

?>
<div class="wrap">
    <h1><?php _e('AIOX Capsules', 'aiox-publisher-suite-pro'); ?></h1>
    
    <div class="notice notice-error">
        <p><strong><?php _e('Capsules Feature Unavailable', 'aiox-publisher-suite-pro'); ?></strong></p>
        <p><?php _e('The Capsules feature is currently unavailable due to a configuration issue. Please check the following:', 'aiox-publisher-suite-pro'); ?></p>
        <ul>
            <li><?php _e('Ensure all plugin files are properly uploaded', 'aiox-publisher-suite-pro'); ?></li>
            <li><?php _e('Check that the database tables were created successfully', 'aiox-publisher-suite-pro'); ?></li>
            <li><?php _e('Verify file permissions are correct', 'aiox-publisher-suite-pro'); ?></li>
        </ul>
    </div>
    
    <div class="aiox-debug-section">
        <h2><?php _e('Debug Information', 'aiox-publisher-suite-pro'); ?></h2>
        <p><?php _e('For detailed debugging information, visit:', 'aiox-publisher-suite-pro'); ?></p>
        <p><a href="<?php echo plugins_url('test-capsules-debug.php', dirname(__FILE__)); ?>" target="_blank" class="button">
            <?php _e('Run Capsules Debug Test', 'aiox-publisher-suite-pro'); ?>
        </a></p>
    </div>
    
    <div class="aiox-actions-section">
        <h2><?php _e('Available Actions', 'aiox-publisher-suite-pro'); ?></h2>
        <p><a href="<?php echo admin_url('admin.php?page=aiox-settings'); ?>" class="button button-primary">
            <?php _e('Go to AIOX Settings', 'aiox-publisher-suite-pro'); ?>
        </a></p>
        <p><a href="<?php echo admin_url('admin.php?page=aiox-logs'); ?>" class="button">
            <?php _e('Check Error Logs', 'aiox-publisher-suite-pro'); ?>
        </a></p>
    </div>
</div>

<style>
.aiox-debug-section, .aiox-actions-section {
    margin-top: 20px;
    padding: 15px;
    background: #f9f9f9;
    border: 1px solid #ddd;
}

.aiox-debug-section h2, .aiox-actions-section h2 {
    margin-top: 0;
}
</style>
