<?php
/**
 * Minimal Capsules Page - Cannot cause critical errors
 */

if (!defined('ABSPATH')) {
    exit;
}

?>
<div class="wrap">
    <h1><?php _e('AIOX Capsules', 'aiox-publisher-suite-pro'); ?></h1>
    
    <div class="notice notice-info">
        <p><strong><?php _e('Minimal Mode Active', 'aiox-publisher-suite-pro'); ?></strong></p>
        <p><?php _e('Running in minimal mode to prevent critical errors while we diagnose the issue.', 'aiox-publisher-suite-pro'); ?></p>
    </div>
    
    <div class="aiox-minimal-content">
        <h2><?php _e('System Information', 'aiox-publisher-suite-pro'); ?></h2>
        
        <table class="widefat">
            <tr>
                <td><strong>WordPress Version:</strong></td>
                <td><?php echo get_bloginfo('version'); ?></td>
            </tr>
            <tr>
                <td><strong>PHP Version:</strong></td>
                <td><?php echo PHP_VERSION; ?></td>
            </tr>
            <tr>
                <td><strong>Plugin Directory:</strong></td>
                <td><?php echo defined('AIOX_PLUGIN_DIR') ? AIOX_PLUGIN_DIR : 'Not Defined'; ?></td>
            </tr>
            <tr>
                <td><strong>Current Time:</strong></td>
                <td><?php echo current_time('mysql'); ?></td>
            </tr>
            <tr>
                <td><strong>Memory Limit:</strong></td>
                <td><?php echo ini_get('memory_limit'); ?></td>
            </tr>
        </table>
        
        <h2><?php _e('Class Status', 'aiox-publisher-suite-pro'); ?></h2>
        
        <table class="widefat">
            <?php
            $classes = array(
                'AIOX_Publisher_Suite_Pro' => 'Main Plugin Class',
                'AIOX_Logger' => 'Logger Class',
                'AIOX_Capsule' => 'Capsule Class',
                'AIOX_Capsule_Manager' => 'Capsule Manager Class',
                'AIOX_Capsule_Generator' => 'Capsule Generator Class',
                'AIOX_Capsules' => 'Capsules Admin Class'
            );
            
            foreach ($classes as $class => $description) {
                $exists = class_exists($class);
                echo '<tr>';
                echo '<td><strong>' . esc_html($description) . ':</strong></td>';
                echo '<td>' . ($exists ? '<span style="color: green;">✓ Available</span>' : '<span style="color: red;">✗ Not Found</span>') . '</td>';
                echo '</tr>';
            }
            ?>
        </table>
        
        <h2><?php _e('Database Status', 'aiox-publisher-suite-pro'); ?></h2>
        
        <table class="widefat">
            <?php
            global $wpdb;
            $table_name = $wpdb->prefix . 'aiox_capsules';
            $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name;
            ?>
            <tr>
                <td><strong>Capsules Table:</strong></td>
                <td><?php echo $table_exists ? '<span style="color: green;">✓ Exists</span>' : '<span style="color: red;">✗ Not Found</span>'; ?></td>
            </tr>
            <?php if ($table_exists): ?>
            <tr>
                <td><strong>Table Name:</strong></td>
                <td><?php echo esc_html($table_name); ?></td>
            </tr>
            <tr>
                <td><strong>Record Count:</strong></td>
                <td><?php echo $wpdb->get_var("SELECT COUNT(*) FROM $table_name"); ?></td>
            </tr>
            <?php endif; ?>
        </table>
        
        <h2><?php _e('Available Actions', 'aiox-publisher-suite-pro'); ?></h2>
        
        <p><a href="<?php echo admin_url('admin.php?page=aiox-settings'); ?>" class="button button-primary">
            <?php _e('AIOX Settings', 'aiox-publisher-suite-pro'); ?>
        </a></p>
        
        <p><a href="<?php echo admin_url('admin.php?page=aiox-logs'); ?>" class="button">
            <?php _e('Error Logs', 'aiox-publisher-suite-pro'); ?>
        </a></p>
        
        <p><a href="<?php echo plugins_url('test-capsules-debug.php', dirname(__FILE__)); ?>" target="_blank" class="button">
            <?php _e('Full Debug Report', 'aiox-publisher-suite-pro'); ?>
        </a></p>
        
        <h2><?php _e('Error Investigation', 'aiox-publisher-suite-pro'); ?></h2>
        
        <p><?php _e('To help identify the exact cause of the critical error, please:', 'aiox-publisher-suite-pro'); ?></p>
        <ol>
            <li><?php _e('Check your WordPress error log (usually in wp-content/debug.log)', 'aiox-publisher-suite-pro'); ?></li>
            <li><?php _e('Look for any PHP fatal errors related to AIOX or Capsules', 'aiox-publisher-suite-pro'); ?></li>
            <li><?php _e('Note the exact file and line number mentioned in the error', 'aiox-publisher-suite-pro'); ?></li>
            <li><?php _e('Share the specific error message for targeted fixing', 'aiox-publisher-suite-pro'); ?></li>
        </ol>
        
        <div style="background: #f0f0f0; padding: 15px; margin: 20px 0;">
            <h3><?php _e('Enable WordPress Debug Logging', 'aiox-publisher-suite-pro'); ?></h3>
            <p><?php _e('Add these lines to your wp-config.php file to capture the exact error:', 'aiox-publisher-suite-pro'); ?></p>
            <code style="display: block; background: white; padding: 10px; margin: 10px 0;">
                define('WP_DEBUG', true);<br>
                define('WP_DEBUG_LOG', true);<br>
                define('WP_DEBUG_DISPLAY', false);
            </code>
            <p><?php _e('Then visit the Capsules page again and check wp-content/debug.log for the exact error.', 'aiox-publisher-suite-pro'); ?></p>
        </div>
    </div>
</div>

<style>
.aiox-minimal-content {
    margin-top: 20px;
}

.aiox-minimal-content table {
    margin-bottom: 20px;
}

.aiox-minimal-content table td {
    padding: 8px;
}

.aiox-minimal-content ol {
    margin-left: 20px;
}

.aiox-minimal-content code {
    font-family: monospace;
    font-size: 14px;
}
</style>
