<?php
/**
 * AIOX Inline JSON Output
 */

if (!defined('ABSPATH')) {
    exit;
}

class AIOX_Inline_JSON {

    public function __construct() {
        add_action('wp_head', array($this, 'output_inline_json'));
    }

    public function output_inline_json($content = '') {
        // Check if feature is enabled
        if (!AIOX_Utils::is_feature_enabled('inline_json')) {
            return;
        }
        
        if (!is_singular()) {
            return;
        }

        global $post;
        $post_id = $post->ID;

        $ingredients = get_post_meta($post_id, '_aiox_ingredients', true);

        if (empty($ingredients)) {
            return;
        }

        $json_ld = array(
            '@context' => 'https://schema.org',
            '@type' => 'Article',
            'headline' => get_the_title($post_id),
            'url' => get_permalink($post_id),
            'datePublished' => get_the_date('c', $post_id),
            'dateModified' => get_the_modified_date('c', $post_id),
            'author' => array(
                '@type' => 'Person',
                'name' => get_the_author_meta('display_name', $post->post_author)
            ),
        );

        // Add AIOX-specific data
        if (isset($ingredients['summary'])) {
            $json_ld['description'] = wp_strip_all_tags($ingredients['summary']);
        }

        if (isset($ingredients['keywords']) && is_array($ingredients['keywords'])) {
            $json_ld['keywords'] = implode(', ', $ingredients['keywords']);
        }

        // Add AIOX metadata
        $json_ld['aiox'] = array(
            'processed' => true,
            'version' => defined('AIOX_VERSION') ? AIOX_VERSION : '2.0.0',
            'ingredients_count' => (is_array($ingredients) ? count($ingredients) : 0),
            'processing_method' => get_post_meta($post_id, '_aiox_method', true) ?: 'basic'
        );

        // Output the JSON-LD
        echo '<script type="application/ld+json">' . "\n";
        echo wp_json_encode($json_ld, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        echo "\n" . '</script>' . "\n";
    }
}