<?php
/**
 * AIOX Post Deletion Handler
 * Handles cleanup when posts are deleted
 */

if (!defined('ABSPATH')) {
    exit;
}

class AIOX_Post_Deletion_Handler {
    
    public function __construct() {
        add_action('before_delete_post', array($this, 'handle_post_deletion'));
        add_action('wp_trash_post', array($this, 'handle_post_trash'));
    }
    
    /**
     * Handle post deletion - clean up all AIOX components
     */
    public function handle_post_deletion($post_id) {
        $post = get_post($post_id);
        
        // Only handle posts and pages
        if (!$post || !in_array($post->post_type, array('post', 'page'))) {
            return;
        }
        
        AIOX_Logger::info("Post Deletion Handler: Cleaning up components for deleted post {$post_id}");
        
        try {
            $comprehensive_processor = new AIOX_Comprehensive_Processor();
            $comprehensive_processor->delete_post_components($post_id);
            
        } catch (Exception $e) {
            AIOX_Logger::error("Post Deletion Handler: Failed to clean up post {$post_id}: " . $e->getMessage());
        }
    }
    
    /**
     * Handle post being moved to trash
     */
    public function handle_post_trash($post_id) {
        // For now, we'll clean up when trashed too
        // In the future, we might want to keep data until permanent deletion
        $this->handle_post_deletion($post_id);
    }
}
