/**
 * AIOX Analytics Front-End Logger
 * -------------------------------
 * Sends a one-time ping when the AIOX badge is visible.
 * No cookies, no personal data, no persistent tracking.
 */

(function() {
  if (typeof AIOXAnalytics === 'undefined' || !AIOXAnalytics.ajaxurl) return;

  const badge = document.querySelector('.aiox-badge'); // adapt if your badge uses a different selector
  if (!badge) return;

  let sent = false;

  function sendPing() {
    if (sent) return;
    sent = true;

    const data = new FormData();
    data.append('action', 'aiox_log_badge');
    data.append('page', window.location.href);

    fetch(AIOXAnalytics.ajaxurl, {
      method: 'POST',
      credentials: 'omit',
      body: data
    }).catch(() => {});
  }

  // Wait until badge becomes visible in viewport
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        sendPing();
        observer.disconnect();
      }
    });
  });

  observer.observe(badge);

  // Fallback: if badge never intersects, ping after 10s anyway
  setTimeout(sendPing, 10000);
})();
