<?php
/**
 * AIOX Suite Pro - Uninstall Script
 * 
 * This file is executed when the plugin is deleted (not just deactivated)
 * 
 * IMPORTANT: This script intentionally preserves ALL data so that if the plugin 
 * is reinstalled, everything returns to exactly how it was before.
 * 
 * This script PRESERVES:
 * - All files in .well-known directory (manifest, capsules, etc.)
 * - All files in uploads/aiox directory
 * - All post meta (_aiox_* keys) - processed posts remain processed
 * - All plugin settings/options - configuration is retained
 * - Database tables (aiox_queue, aiox_capsules, aiox_logs) - all data retained
 * 
 * To completely remove all AIOX data, use the "Total Reset" button in AIOX Settings
 * before uninstalling the plugin.
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Main uninstall function
 * 
 * Intentionally does nothing to preserve all data for reinstallation
 */
function aiox_uninstall() {
    // Clear any cached data only
    wp_cache_flush();
    
    // ALL DATA IS PRESERVED:
    // - .well-known files (manifest, capsules, tdmrep, etc.)
    // - Upload directory files
    // - Database tables
    // - Post meta
    // - Plugin options
    //
    // Use "Total Reset" in AIOX Settings to remove all data before uninstalling
}

// Execute the uninstall
aiox_uninstall();
